<?php



class Payout extends AppModel
{
    public $useTable = 'payout';

    public $belongsTo = array(
        'User' => array(
            'className' => 'User',
            'foreignKey' => 'user_id',
            'fields' => USER_FIELDS
        ),


    );

    public function getDetails($id)
    {

        return $this->find('first', array(
            'conditions' => array('Payout.id' => $id)
        ));

    }

    public function ifExist($user_id){

        return $this->find('first', array(
            'conditions' => array(


                'Payout.user_id' => $user_id,




            ),
        ));

    }

    public function getUserCards($user_id)
    {
        return $this->find('all', array(
            'conditions' => array(

                'PaymentCard.user_id' => $user_id,




            ),
            'fields'=>array('stripe','id'),
        ));


    }

}